#include <SPI.h>
#include <Ethernet.h>
#include <EthernetUdp.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include "FS.h"
#include "SD.h"
#include "RTClib.h"  

RTC_DS3231 rtc; 
char daysOfTheWeek[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

// Enter a MAC address for your controller below.
// Newer Ethernet shields have a MAC address printed on a sticker on the shield
byte mac[] = {0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED};

unsigned int localPort = 8888;       // local port to listen for UDP packets

const char timeServer[] = "time.nist.gov"; // time.nist.gov NTP server

const int NTP_PACKET_SIZE = 48; // NTP time stamp is in the first 48 bytes of the message

byte packetBuffer[NTP_PACKET_SIZE]; //buffer to hold incoming and outgoing packets

EthernetUDP Udp;// A UDP instance to let us send and receive packets over UDP

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

int ledPin1 = 2;
int ledPin2 = 4;
int ledPin3 = 12;
int ledPin4 = 13;

int  buttonState = 0;
const int buttonPin = 36;


static const uint8_t image_data_Saraarray[1024] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0xfc, 0x1f, 0x80, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0xf8, 0x0f, 0x80, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf8, 0x07, 0x80, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x03, 0xf8, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xf0, 0x07, 0x80, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xd8, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x01, 0xe3, 0x80, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x7f, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x3c, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x0f, 0x01, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x3f, 0xe1, 0xe0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x7f, 0xf1, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf8, 0xf9, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x79, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x39, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x39, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, -1);

void setup() {
                            // Declare FLOW CONTROL pin as output
  Serial.begin(9600);                              // set serial communication baudrate

  pinMode(34, INPUT);
  pinMode(33, INPUT);
  pinMode(14, INPUT);
  pinMode(21, INPUT);
  pinMode(35, INPUT);
  pinMode(25, INPUT);
  pinMode(32, INPUT);
  pinMode(22, INPUT);
  pinMode(buttonPin,INPUT);
  
  pinMode(ledPin1, OUTPUT);
  pinMode(ledPin2, OUTPUT);
  pinMode(ledPin3, OUTPUT);
  pinMode(ledPin4, OUTPUT);



  Wire.begin(16, 17);                            // Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.clearDisplay();
  display.display();

  display.drawBitmap(0, 0, image_data_Saraarray, 128, 64, 1);
  display.display();
  delay(2000);
  display.clearDisplay();
  display.display();

  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(15, 15);
  display.println("NORVI ENET-AE06-R");
  display.setCursor(45, 30);
  display.println("HELLO...");
  display.setCursor(25, 45);
  display.println("Test code V1.0");
  display.display();
  delay(2000);
  display.clearDisplay();
  display.display();



if (! rtc.begin()) {
    Serial.println("Couldn't find RTC");
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.setCursor(15,15);
    display.println("Couldn't find RTC");
    display.display();
    delay(2000);
    display.clearDisplay();
    display.display();
 }
 else{
 if (rtc.lostPower()) {
  
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.setCursor(25, 15);
    display.println("RTC lost power");
    display.setCursor(30, 35);
    display.println("Set the time!");
    Serial.println("RTC lost power, lets set the time!");
    display.display();
    delay(3000);
    display.clearDisplay();
    display.display();
 
    // If the RTC have lost power it will sets the RTC to the date & time this sketch was compiled in the following line
    // set time from computer time
    // This line sets the RTC with an explicit date & time, for example to set
    // January 21, 2014 at 3am you would call:
    // rtc.adjust(DateTime(2021, 3, 30, 11, 55, 0));
  }

  rtc.adjust(DateTime(F(__DATE__), F(__TIME__))); 
  int a=1;
  while(a<6)
 {
  displayTime();   // printing time function for oled
  a=a+1;
}
 }
  display.display();
  delay(2000);
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 5);

  uint8_t cardType = SD.cardType();
  
    if(SD.begin())
 {
  Serial.println("Card Mount: success");
  display.println("Card Mount: success");
  display.setCursor(0, 20);
  Serial.print("Card Type: ");
  display.print("Card Type: ");

  display.setCursor(65,20 );
    if(cardType == CARD_MMC){
        Serial.println("MMC");
        display.println("MMC");
    } else if(cardType == CARD_SD){
        Serial.println("SDSC");
        display.println("SDSC");
    } else if(cardType == CARD_SDHC){
        Serial.println("SDHC");
        display.println("SDHC");
    } else {
        Serial.println("Unknown");
        display.println("Unknown");
    }

  display.setCursor(0, 35);
  int cardSize = SD.cardSize() / (1024 * 1024);
  Serial.printf("Card Size: %lluMB\n", cardSize);
  display.println("Card Size:");
  display.setCursor(65,35);
  display.println(cardSize);
}

  if(!SD.begin())
{
  display.setCursor(35, 15);
  Serial.println("NO SD card");  
  display.println("NO SD card");           
}

display.display();
delay(3500);
display.clearDisplay();
display.display();



  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.println("Checking the status");
  display.display();
  Ethernet.init(26);  // ESP32 with Adafruit Featherwing Ethernet
 

  // start Ethernet and UDP
  if (Ethernet.begin(mac) == 0) {
  Serial.println("Failed to configure Ethernet using DHCP");
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.println("Failed Enet");
  display.display();
  delay(2000);
  display.clearDisplay();
  display.display();

    // Check for Ethernet hardware present
  if (Ethernet.hardwareStatus() == EthernetNoHardware) {
  Serial.println("Ethernet shield was not found.  Sorry, can't run without hardware. :(");
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.println("Enet not found");
  display.display();
  delay(2000);
  display.clearDisplay();
  display.display();
  
    }
    if (Ethernet.linkStatus() == LinkOFF) {
      Serial.println("Ethernet cable is not connected.");
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.println("Enet not connected");
  display.display();
 delay(2000);
  display.clearDisplay();
  display.display();
    }
  }
  
 else{
  Udp.begin(localPort);
 
  sendNTPpacket(timeServer); // send an NTP packet to a time server

  // wait to see if a reply is available
  delay(1000);
  if (Udp.parsePacket()) {
    // We've received a packet, read the data from it
    Udp.read(packetBuffer, NTP_PACKET_SIZE); // read the packet into the buffer

    // the timestamp starts at byte 40 of the received packet and is four bytes,
    // or two words, long. First, extract the two words:

    unsigned long highWord = word(packetBuffer[40], packetBuffer[41]);
    unsigned long lowWord = word(packetBuffer[42], packetBuffer[43]);
    // combine the four bytes (two words) into a long integer
    // this is NTP time (seconds since Jan 1 1900):
    unsigned long secsSince1900 = highWord << 16 | lowWord;
    Serial.print("Seconds since Jan 1 1900 = ");
    Serial.println(secsSince1900);

    // now convert NTP time into everyday time:
    Serial.print("Unix time = ");
    // Unix time starts on Jan 1 1970. In seconds, that's 2208988800:
    const unsigned long seventyYears = 2208988800UL;
    // subtract seventy years:
    unsigned long epoch = secsSince1900 - seventyYears;
    // print Unix time:
    Serial.println(epoch);


    // print the hour, minute and second:
   Serial.print("The UTC time is ");
   display.clearDisplay();
   display.setTextSize(1);
   display.setTextColor(WHITE);
   display.setCursor(40, 0);
   display.println("UTC time");
   display.setCursor(10, 40);
   display.println("Ethernet Connected");
   
   // UTC is the time at Greenwich Meridian (GMT)
   display.setCursor(40, 15);
   display.println((epoch  % 86400L) / 3600);
   
    Serial.print((epoch  % 86400L) / 3600);
    // print the hour (86400 equals secs per day)
    display.setCursor(50, 15);
     display.println(":");
    Serial.print(':');
    if (((epoch % 3600) / 60) < 10) {
      // In the first 10 minutes of each hour, we'll want a leading '0'
      Serial.print('0');
    }
    
    display.setCursor(58, 15);
    display.println((epoch  % 3600) / 60);
    
    Serial.print((epoch  % 3600) / 60); // print the minute (3600 equals secs per minute)
     display.setCursor(70, 15);
     display.println(":");
    Serial.print(':');
    if ((epoch % 60) < 10) {
      // In the first 10 seconds of each minute, we'll want a leading '0'
      Serial.print('0');
    }
    display.setCursor(75, 15);
    display.println(epoch % 60);
    
    Serial.println(epoch % 60); // print the second
    display.display();
  }
  // wait ten seconds before asking for the time again
  delay(3000);
  Ethernet.maintain();
 }
}

void loop()
{
  display.clearDisplay();
  update();
  digitalWrite(ledPin1, HIGH);
  update();
  digitalWrite(ledPin1, LOW);
  digitalWrite(ledPin2, HIGH);
  update();
  digitalWrite(ledPin2, LOW);
  digitalWrite(ledPin3, HIGH);
  update();
  digitalWrite(ledPin3, LOW);
  digitalWrite(ledPin4, HIGH);
  update();
  digitalWrite(ledPin4, LOW);

}
void update()
{
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(45, 5);
  display.println("1");
  display.setCursor(55, 5);
  display.println("2");
  display.setCursor(65, 5);
  display.println("3");
  display.setCursor(75, 5);
  display.println("4");
  display.setCursor(85, 5);
  display.println("5");
  display.setCursor(95, 5);
  display.println("6");
  display.setCursor(105, 5);
  display.println("7");
  display.setCursor(115, 5);
  display.println("8");
  delay(500);
  
  display.setCursor(0, 20);
  display.println("Inputs");
  display.setCursor(45, 20);
  display.println(digitalRead(21));
  display.setCursor(55, 20);
  display.println(digitalRead(14));
  display.setCursor(65, 20);
  display.println(digitalRead(33));
  display.setCursor(75, 20);
  display.println(digitalRead(34));
  display.setCursor(85, 20);
  display.println(digitalRead(35));
  display.setCursor(95, 20);
  display.println(digitalRead(25));
  display.setCursor(105, 20);
  display.println(digitalRead(32));
  display.setCursor(115, 20);
  display.println(digitalRead(22));

  display.setCursor(0, 30);
  display.println("Outputs");
  display.setCursor(45, 30);
  display.println(digitalRead(02));
  display.setCursor(55, 30);
  display.println(digitalRead(04));
  display.setCursor(65, 30);
  display.println(digitalRead(12));
  display.setCursor(75, 30);
  display.println(digitalRead(13));

  display.setCursor(20, 45);
  display.println("Button State");
  buttonState = analogRead(buttonPin);
  delay(50);
  display.setCursor(100, 45);
  display.println(analogRead(buttonPin));
  display.display();
  display.clearDisplay();

}
// send an NTP request to the time server at the given address
void sendNTPpacket(const char * address) 
{
  // set all bytes in the buffer to 0
  memset(packetBuffer, 0, NTP_PACKET_SIZE);
  // Initialize values needed to form NTP request
  // (see URL above for details on the packets)
  packetBuffer[0] = 0b11100011;   // LI, Version, Mode
  packetBuffer[1] = 0;     // Stratum, or type of clock
  packetBuffer[2] = 6;     // Polling Interval
  packetBuffer[3] = 0xEC;  // Peer Clock Precision
  // 8 bytes of zero for Root Delay & Root Dispersion
  packetBuffer[12]  = 49;
  packetBuffer[13]  = 0x4E;
  packetBuffer[14]  = 49;
  packetBuffer[15]  = 52;

  // all NTP fields have been given values, now
  // you can send a packet requesting a timestamp:
  Udp.beginPacket(address, 123); // NTP requests are to port 123
  Udp.write(packetBuffer, NTP_PACKET_SIZE);
  Udp.endPacket(); 
}

void displayTime(void) {
  DateTime now = rtc.now();
  display.setTextSize(1);             
  display.setTextColor(SSD1306_WHITE);       
 
  display.setCursor(10, 15);        
  display.print(now.year(), DEC);
  display.print('/');
  display.print(now.month(), DEC);
  display.print('/');
  display.print(now.day(), DEC);
  display.print(" ");
  display.print(daysOfTheWeek[now.dayOfTheWeek()]);

  display.setTextSize(2);
  display.setCursor(15, 30);  
  display.print(now.hour(), DEC);
  display.print(':');
  display.print(now.minute(), DEC);
  display.print(':');
  display.print(now.second(), DEC);
  display.println();
  delay(1000);
  display.display();
  display.clearDisplay();
}
